class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Wired Magazine'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:bold;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='div',attrs={'id':'content'})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['entryDescription','entryActions','bio','prev-next-nav',
                      'wp-caption alignleft','portlet','thumb tleft','creative_commons_copy','suboffer']}),
                   dict(name='div', attrs={'id':['post_nav','header','social_bookmarking_module','register_mod',
                    'forgot_password_module','sign_in_or_register','commenting_module','blog_slideshow_previous_next',
                    'blog_slideshow_previous_next_bottom','start_stop_play_index','department_bar','nav_bar','jump-to-nav',
                    'toolbox_art_bot','catlinks','footer']}),
                   dict(name='ul', attrs={'class':['commentlist','ngg-gallery-list']}),
                   dict(name='ul', attrs={'id':['']}),
	dict(name='ol', attrs={'id':['']}),
	dict(name='span', attrs={'class':['']}),
	dict(name='h3', attrs={'id':'siteSub'}),
                   dict(name=['img','br'],)]

    feeds          = [(u'Top Stories', u'http://feeds.wired.com/wired/index?format=xml'), 
                          (u'Gadget Lab', u'http://www.wired.com/gadgetlab/feed/'), 
                          (u'Reviews', u'http://www.wired.com/reviews/feed/'), 
                          (u'How To', u'http://feeds.wired.com/howtowiki?format=xml')]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds